
#ifdef _DEBUG
#include <crtdbg.h>
#define _crtdbg_map_alloc
#define new  ::new(_normal_block, __file__, __line__)
#endif

#include <windows.h>
#include <stdio.h>
#include <winnls.h>

#define	TO_EXIT(S) {ToExit(S);goto FINISH;}

typedef unsigned long tUINT32;
typedef signed long tINT32;

void ToExit(char *msg);
void swap4(tUINT32 *val);

FILE	*fp_r;
FILE	*fp_w;
tUINT32	*a_offset;
char	**a_filename;

void ToExit(char *msg)
{
	int		loop1;

	if (fp_w != NULL) {fclose(fp_w); fp_w = NULL;}
	if (fp_r != NULL) {fclose(fp_r); fp_r = NULL;}
	if (a_offset != NULL) {free(a_offset); a_offset = NULL;}
	if (a_filename != NULL) {
		for(loop1=0;; loop1++) {
			if (a_filename[loop1] != NULL) {
				free(a_filename[loop1]); a_filename[loop1] = NULL;
			}
			else {
				break;
			}
		}
		free(a_filename); a_filename = NULL;
	}
}

void swap4(tUINT32 *val)
{
	*val = ((*val<<24) & 0xFF000000) | ((*val<<8) & 0xFF0000) | ((*val>>8) & 0xFF00) | ((*val>>24) & 0xFF);
}

int main(int argc, char* argv[])
{
	tUINT32	IndexCount;
	size_t	ret_size_t;
	int		ret_int;
	int		loop1;
	tUINT32	NameLen;
	char	*NameUnicode;
	tUINT32	rawsize;
	void	*RawPcm;
	tINT32	pos_now, pos_end;

#ifdef _DEBUG
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
#endif

	fp_r = NULL;
	fp_w = NULL;
	a_offset = NULL;
	a_filename = NULL;

	if (argc<2) {
		fp_r = fopen("C:\\Leaf\\ł́II\\FDCGR\\bgm.dat", "rb");
	}
	else {
		fp_r = fopen(argv[1], "rb");
	}

	if (fp_r == NULL) {TO_EXIT("");}
	ret_size_t = fread(&IndexCount, 1, 4, fp_r); swap4(&IndexCount);
	if (ret_size_t < 4) {TO_EXIT("");}
	a_filename = (char **)malloc(sizeof(char **) * (IndexCount+1));
	if (a_filename == NULL) {TO_EXIT("");}
	a_offset = (tUINT32 *)malloc(sizeof(tUINT32) * (IndexCount+1));
	if (a_offset == NULL) {TO_EXIT("");}
	for(loop1=0; loop1<(int)IndexCount+1; loop1++) {
		a_filename[loop1] = NULL;
	}
	for(loop1=0; loop1<(int)IndexCount; loop1++) {
		ret_size_t = fread(&NameLen, 1, 4, fp_r); swap4(&NameLen);
		if (ret_size_t < 4) {TO_EXIT("");}
		NameUnicode = (char*)malloc((NameLen+1)*2);
		if (NameUnicode == NULL) {TO_EXIT("");}
		ret_size_t = fread(NameUnicode, 1, NameLen*2, fp_r);
		if (ret_size_t < 4) {TO_EXIT("");}
		NameUnicode[NameLen*2] = 0;
		NameUnicode[NameLen*2+1] = 0;
		ret_int = WideCharToMultiByte(CP_THREAD_ACP, 0, (LPCWSTR)NameUnicode, -1, NULL, 0, NULL, NULL);
		a_filename[loop1] = (char*)malloc(ret_int+1);
		if (a_filename[loop1] == NULL) {TO_EXIT("");}
		ret_int = WideCharToMultiByte(CP_THREAD_ACP, 0, (LPCWSTR)NameUnicode, -1, a_filename[loop1], ret_int, NULL, NULL);
		a_filename[loop1][ret_int] = 0;	// Ô
		free(NameUnicode);
		ret_size_t = fread(&(a_offset[loop1]), 1, 4, fp_r); swap4(&(a_offset[loop1]));
		if (ret_size_t < 4) {TO_EXIT("");}
	}
	a_offset[IndexCount] = 0xFFFFFFFF;
	for(loop1=0; loop1<(int)IndexCount; loop1++) {
		if (a_offset[loop1+1] == 0xFFFFFFFF) {
			pos_now = ftell(fp_r);
			ret_int = fseek(fp_r, 0, SEEK_END);
			if (ret_int != 0) {TO_EXIT("");}
			pos_end = ftell(fp_r);
			ret_int = fseek(fp_r, pos_now, SEEK_SET);
			if (ret_int != 0) {TO_EXIT("");}
			rawsize = pos_end - pos_now;
		}
		else {
			rawsize = a_offset[loop1+1]-a_offset[loop1];
		}
		fp_w = fopen(a_filename[loop1], "wb");
		if (fp_w == NULL) {TO_EXIT("");}
		RawPcm = malloc(rawsize);
		if (RawPcm == NULL) {TO_EXIT("");}
		ret_size_t = fread(RawPcm, 1, rawsize, fp_r);
		if (ret_size_t != rawsize) {TO_EXIT("");}
		// Todo: WAVt@C̃wb_[ƏݏKvB
		ret_size_t = fwrite(RawPcm, 1, rawsize, fp_w);
		free(RawPcm);
		fclose(fp_w);
	}

	TO_EXIT("");
FINISH:
	return 0;
}
